/*
 * Decompiled with CFR 0.152.
 */
package cloud.lemonslice.teastory.block.crops;

import cloud.lemonslice.teastory.helper.VoxelShapeHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.PlantType;

public class MelonVineBlock
extends BushBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61409_;
    private static final VoxelShape SHAPE = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 0.0, 16.0, 5.0, 16.0);
    private static final VoxelShape SHAPE_MELON = VoxelShapeHelper.createVoxelShape(0.0, 0.0, 0.0, 16.0, 13.0, 16.0);
    private final Block melon;

    public MelonVineBlock(BlockBehaviour.Properties copy, Block melon) {
        super(copy);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
        this.melon = melon;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return (Integer)state.m_61143_((Property)AGE) == 7 ? SHAPE_MELON : SHAPE;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (player.m_21120_(handIn).m_41720_() == Items.f_42574_ && (Integer)state.m_61143_((Property)AGE) == 7) {
            player.m_21120_(handIn).m_41622_(1, (LivingEntity)player, e -> e.m_21190_(handIn));
            worldIn.m_46597_(pos, this.m_49966_());
            if (!worldIn.m_5776_()) {
                Block.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)new ItemStack((ItemLike)this.melon));
                worldIn.m_5594_(null, pos, SoundEvents.f_12344_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean m_6266_(BlockState state, BlockGetter worldIn, BlockPos pos) {
        return state.m_204336_(BlockTags.f_144274_) || state.m_60734_() instanceof FarmBlock || MelonVineBlock.m_49936_((BlockGetter)worldIn, (BlockPos)pos);
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 20;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 5;
    }

    public void m_213898_(BlockState state, ServerLevel worldIn, BlockPos pos, RandomSource random) {
        float f;
        if (!worldIn.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!this.m_7370_((LevelReader)worldIn, pos, state, false)) {
            return;
        }
        if (MelonVineBlock.hasNearMelon(worldIn, pos, (Block)this)) {
            return;
        }
        if (worldIn.m_45524_(pos, 0) >= 9 && ForgeHooks.onCropsGrowPre((Level)worldIn, (BlockPos)pos, (BlockState)state, (random.m_188503_((int)(25.0f / (f = MelonVineBlock.getGrowthChance((Block)this, worldIn, pos))) + 1) == 0 ? 1 : 0) != 0)) {
            int i = (Integer)state.m_61143_((Property)AGE);
            if (i + 1 < 7) {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i + 1)), 2);
                BlockPos blockPos = pos.m_121945_(Direction.Plane.HORIZONTAL.m_235690_(random));
                BlockState blockState = worldIn.m_8055_(blockPos);
                if (blockState.m_60795_() && this.m_6266_(worldIn.m_8055_(blockPos.m_7495_()), (BlockGetter)worldIn, blockPos.m_7495_())) {
                    worldIn.m_46597_(blockPos, this.m_49966_());
                }
            } else {
                worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(7)), 2);
            }
            ForgeHooks.onCropsGrowPost((Level)worldIn, (BlockPos)pos, (BlockState)state);
        }
    }

    public static boolean hasNearMelon(ServerLevel worldIn, BlockPos pos, Block melon) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockState state = worldIn.m_8055_(pos.m_121945_(direction));
            if (!state.m_60713_(melon) || (Integer)state.m_61143_((Property)AGE) != 7) continue;
            return true;
        }
        return false;
    }

    public boolean m_7370_(LevelReader p_256559_, BlockPos p_50898_, BlockState p_50899_, boolean p_50900_) {
        return true;
    }

    public boolean m_214167_(Level worldIn, RandomSource p_220879_, BlockPos pos, BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 7 && worldIn.m_8055_(pos.m_7495_()).m_60734_() instanceof FarmBlock;
    }

    public void m_214148_(ServerLevel worldIn, RandomSource rand, BlockPos pos, BlockState state) {
        int i = Math.min(7, (Integer)state.m_61143_((Property)AGE) + Mth.m_216271_((RandomSource)worldIn.m_213780_(), (int)2, (int)5));
        worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(i)), 2);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{AGE}));
    }

    public PlantType getPlantType(BlockGetter level, BlockPos pos) {
        return PlantType.CROP;
    }

    protected static float getGrowthChance(Block blockIn, ServerLevel worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.m_7495_();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                BlockState blockstate = worldIn.m_8055_(blockpos.m_7918_(i, 0, j));
                if (blockstate.canSustainPlant((BlockGetter)worldIn, blockpos.m_7918_(i, 0, j), Direction.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (blockstate.isFertile((BlockGetter)worldIn, pos.m_7918_(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.m_122012_();
        BlockPos blockpos2 = pos.m_122019_();
        BlockPos blockpos3 = pos.m_122024_();
        BlockPos blockpos4 = pos.m_122029_();
        boolean flag = blockIn == worldIn.m_8055_(blockpos3).m_60734_() || blockIn == worldIn.m_8055_(blockpos4).m_60734_();
        boolean bl = flag1 = blockIn == worldIn.m_8055_(blockpos1).m_60734_() || blockIn == worldIn.m_8055_(blockpos2).m_60734_();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.m_8055_(blockpos3.m_122012_()).m_60734_() || blockIn == worldIn.m_8055_(blockpos4.m_122012_()).m_60734_() || blockIn == worldIn.m_8055_(blockpos4.m_122019_()).m_60734_() || blockIn == worldIn.m_8055_(blockpos3.m_122019_()).m_60734_();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter level, BlockPos pos, Player player) {
        return new ItemStack((ItemLike)Items.f_42578_);
    }
}

